 ; Ŀ
 ;   Mva - Move the drawing base to 0,0, reset limits.                     
 ;   Mvi - Move selected stuff by the insertion point of the first entity  
 ;         selected, either to 0,0 or to a selected point.                 
 ;   Mvo - Move selected entities to 0,0, reset limits.                    
 ;   Copyright 1990, 1997, 2007 by Rocket Software Ltd.                    
 ;   When those position-dependent macros don't work consistently...       
 ; 

 ; Ŀ
 ;   Mvi - added utility - move entities by the insertion point of the     
 ;   first entity selected.                                                
 ; 
 (DEFUN C:MVI (/ *error* orth osmo ss enam num pa pb)
  (setvar "cmdecho" 0)
  (command ".undo" "be")
  (setq osmo (getvar "osmode"))
  (setvar "osmode" 0)
  (setq orth (getvar "orthomode"))
  (setvar "orthomode" 0)
 ; Ŀ
 ;   Make a local error handler.                                           
 ; 
 (defun *error* (shk /)
  (setvar "osmode" osmo)
  (setvar "orthomode" orth)
  (command ".undo" "end")
  (write-line shk)
 (princ))
 ; Ŀ
 ;   Get and move an ss.                                                   
 ; 
  (if (setq ss (ssget))
      (progn
           (setq pa (ginst (ssname ss 0)))
           (setq pb (getpoint pa "New location <0,0>: "))
           (if (null pb) (setq pb '(0 0)))
           (command "move" ss "" pa pb)))
 ; Ŀ
 ;   Clean up and go home.                                                 
 ; 
  (*error* "")
 (princ))
 ; Ŀ
 ;   Mvi end.                                                              
 ; 

 ; Ŀ
 ;   Mvo - added utility - move entities back to 0,0.                      
 ; 
 (DEFUN C:MVO (/ *error* orth osmo ss enam num pa)
  (setvar "cmdecho" 0)
  (command ".undo" "be")
  (setq osmo (getvar "osmode"))
  (setvar "osmode" 0)
  (setq orth (getvar "orthomode"))
  (setvar "orthomode" 0)
 ; Ŀ
 ;   Make a local error handler.                                           
 ; 
 (defun *error* (shk /)
  (setvar "osmode" osmo)
  (setvar "orthomode" orth)
  (command ".undo" "end")
  (write-line shk)
 (princ))
 ; Ŀ
 ;   Get and move an ss.                                                   
 ; 
  (if (setq ss (ssget))
      (progn
           (setq pa (cdr (assoc 10 (entget (ssname ss 0)))))
           (command "move" ss "" pa "0,0")))
 ; Ŀ
 ;   Clean up and go home.                                                 
 ; 
  (*error* "")
 (princ))
 ; Ŀ
 ;   Mvo end.                                                              
 ; 

 ; Ŀ
 ;   Bungee - save the status of all layers for later restoration.         
 ; 
 (DEFUN BUNGEE (/ llist rew lanam sev frizp lockp offp statls)
  (setq allst ())
  (setq rew t)
  (while (setq llist (tblnext "layer" rew))
         (setq rew ())
         (setq lanam (cdr (assoc 2 llist)))
         (setq sev (cdr (assoc 70 llist)))
         (setq frizp (if (= (logand sev 1) 1) t ()))
         (setq lockp (if (= (logand sev 4) 4) t ()))
         (setq offp (if (minusp (cdr (assoc 62 llist))) t ()))
         (setq statls (list lanam frizp lockp offp))
         (setq allst (append allst (list statls))))
 allst)
 ; Ŀ
 ;   Bungee end.                                                           
 ; 

 ; Ŀ
 ;   Ginst: find the true insertion point of an entity.                    
 ;   Arguments: Enam, an entity name.                                      
 ;   Calls Spit, returns a point.                                          
 ; 
 (DEFUN GINST (enam / entt typ pa)
  (setq entt (entget enam))  
  (setq typ (cdr (assoc 0 entt)))
  (cond ((= typ "POLYLINE")
         (setq pa (cdr (assoc 10 (entget (entnext enam))))))
        ((member typ '("TEXT" "ATTRIB"))
         (setq pa (spit entt)))
        (t
         (setq pa (cdr (assoc 10 entt)))))
 pa)
 ; Ŀ
 ;   Ginst end.                                                            
 ; 

 ; Ŀ
 ;   Spit - returns the insertion point of the text entity whose data was  
 ;   passed as its sole argument.  Note that this is not necessarily the   
 ;   same as the 10 association code.                                      
 ; 
 (DEFUN SPIT (entt / xjust yjust)
  (setq xjust (cdr (assoc 72 entt)))
  (setq yjust (cdr (assoc 73 entt)))
  (if (or (/= xjust 0) (/= yjust 0))
      (cdr (assoc 11 entt))
      (cdr (assoc 10 entt))))
 ; Ŀ
 ;   Spit end.                                                             
 ; 

 ; Ŀ
 ;   Splash - restore the previous state of layers.                        
 ; 
 (DEFUN SPLASH (allst / num clam)
 ; Ŀ
 ;   Step through the layers and the status list Allst.                    
 ; 
 (setq num 0)
 (command "layer")
 (while (setq sub (nth num allst))
        (setq num (1+ num))
        (grtext -2 (setq clam (car sub)))
        (setq frizp (nth 1 sub))
        (setq lockp (nth 2 sub))
        (setq offp (nth 3 sub))
        (if frizp (command "freeze" clam) (command "thaw" clam))
        (if lockp (command "lock" clam) (command "unlock" clam))
        (if offp (command "off" clam) (command "on" clam)))
  (command "")
 (princ))
 ; Ŀ
 ;   Splash end.                                                           
 ; 

 ; Ŀ
 ;   Mva.                                                                  
 ; 
 (DEFUN C:MVA (/ *error* orth osmo minn)
  (setvar "cmdecho" 0)
  (command ".undo" "be")
  (setq osmo (getvar "osmode"))
  (setvar "osmode" 0)
  (setq orth (getvar "orthomode"))
  (setvar "orthomode" 0)
 ; Ŀ
 ;   Make a local error handler.                                           
 ; 
 (defun *error* (shk /)
  (setvar "osmode" osmo)
  (setvar "orthomode" orth)
  (command ".undo" "end")
  (write-line shk)
 (princ))
 ; Ŀ
 ;   Move everything.                                                      
 ; 
  (setq allst (bungee))
  (command "layer" "thaw" "*" "on" "*" "unlock" "*" "")
  (command "zoom" "e")
  (setq minn (getvar "extmin"))
  (command "move" "all" "" minn "0,0")
  (command "zoom" "e")
  (setvar "limmin" (reverse (cdr (reverse (getvar "extmin")))))
  (setvar "limmax" (reverse (cdr (reverse (getvar "extmax")))))
  (splash allst)
 ; Ŀ
 ;   Exit neatly.                                                          
 ; 
  (*error* "")
 (princ))